/system logging action
set 1 disk-file-count=3
/system logging
set 0 action=memory prefix=INFO
set 1 action=memory prefix=ERR
set 2 action=disk prefix=WARN
set 3 action=memory prefix=CRIT
add action=memory prefix=SYN topics=async disabled=yes
:log warning "LOGGING_CHANGED";
:delay 3s;

/system routerboard settings set init-delay=5s
/system routerboard usb set type=mini-PCIe
:log warning "MINI-PCI ACTIVATED";
:delay 1s;

:log warning "SET INITIAL PARAMETER";
:global NUM 0;
:global VER [:pick [/system resource get version] 0 4];
:global MODEL [:pick [/system routerboard get model] 0 3];
:global SERIAL [:pick [/system routerboard get serial-number] 7 12];

:log warning "SETTINGS_START_INSTALL";

/system identity
set name=GTX300-S-912BC
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/interface ppp-client
set [ find name=ppp-out1 ] apn=internet comment="3G Internet" default-route-distance=1 \
    dial-on-demand=no disabled=yes info-channel=3 name=ppp-out1 port=usb1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 3s;

/ip neighbor discovery
set ppp-out1 discover=no
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/interface ppp-client
set [ find name=ppp-out1 ] disabled=no
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 10s;

/interface ethernet
set [ find default-name=ether1 ] comment="Local" name="LAN-Master"
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/ip firewall nat
add action=masquerade chain=srcnat comment="Internet To Local" log-prefix="" out-interface=ppp-out1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 2s;

/ip dns
set allow-remote-requests=yes cache-size=4096KiB
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/system clock
set time-zone-autodetect=no time-zone-name=Europe/Moscow
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/system ntp client
set enabled=yes server-dns-names=\
    ntp4.stratum2.ru,ntp3.stratum2.ru,ntp5.stratum1.ru,timeserver.ru
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/system note
set note="\
    \n  TTTTTTTT  EEEEEE  LL      EEEEEE    OOOO    FFFFFF  IIII   SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II   SS\
    \n     TT     EEEEEE  LL      EEEEEE  OO    OO  FFFFFF   II    SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II        SS\
    \n     TT     EEEEEE  LLLLLL  EEEEEE    OOOO    FF      IIII   SSSSS\
    \n\
    \n  Teleofis for MikroTik RouterOS $"VER" (c) 2004-2017  http://teleofis.ru/\
    \n\
    \n"
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1ms;

/system scheduler
add disabled=no interval=10m name=ping_watchdog on-event=":global ITERATION 0;\r\
    \n:global IP1 8.8.8.8;\r\
    \n:global IP2 8.8.4.4;\r\
    \n:log debug \"watchdog: start watchdog\";\r\
    \n:while (true) do={\r\
    \n   :if ([:len [/system resource usb find]] < 2) do={\r\
    \n      :log error \"watchdog: Could not Find Modem Card - Reboot\";\r\
    \n      :delay 2s;\r\
    \n      /system reboot;\r\
    \n      :delay 1ms;\r\
    \n   }\r\
    \n   :if ([/port get number=0 channel] != 7) do={\r\
    \n      :log error \"watchdog: Incorrect Number of Channels - Reboot\";\r\
    \n      :delay 2s;\r\
    \n      /system reboot;\r\
    \n      :delay 1ms;\r\
    \n   }\r\
    \n   :if ([/port find inactive=no] != \"\") do={\r\
    \n      :global PING1 [/ping \$IP1 count=10];\r\
    \n      :if (\$PING1 > 5) do={\r\
    \n         :log debug \"watchdog: Ping 1 Watchdog - Ok\";\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :global PING2 [/ping \$IP2 count=10];\r\
    \n      :if (\$PING2 > 5) do={\r\
    \n         :log debug \"watchdog: Ping 2 Watchdog - Ok\";\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :if (\$ITERATION < 3) do={\r\
    \n         :log warning \"watchdog: Could not Ping - Reconnect\";\r\
    \n         /system routerboard usb power-reset duration=3;\r\
    \n         :log warning \"watchdog: Power Reset Mini-PCIe\";\r\
    \n         :set \$ITERATION (\$ITERATION+1);\r\
    \n         :delay 40s;\r\
    \n      } else={\r\
    \n         :log error \"watchdog: Could not Ping - Reboot\";\r\
    \n         /system routerboard usb power-reset duration=3;\r\
    \n         :delay 2s;\r\
    \n         /system reboot;\r\
    \n         :delay 1ms;\r\
    \n      }\r\
    \n   } else={\r\
    \n      :log error \"watchdog: Could not Find Modem Port - Reboot\";\r\
    \n      :delay 2s;\r\
    \n      /system reboot;\r\
    \n      :delay 1ms;\r\
    \n   }\r\
    \n}" policy=ftp,reboot,read,write,policy,test,password,sniff,sensitive \
    start-time=startup
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

:local G [/system leds find disabled=no];
:if ($G != "") do={
/system leds
set 0 interface=ppp-out1 leds=user-led type=interface-transmit
add interface=ppp-out1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 type=modem-signal
} else={
/system leds
add interface=ppp-out1 type=interface-transmit leds=user-led
add interface=ppp-out1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 type=modem-signal
}
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 2s;

/ip pool
add name=dhcp-pool1 ranges=192.168.88.10-192.168.88.250
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip dhcp-server network
add address=192.168.88.0/24 comment="For Local" dns-server=192.168.88.1 \
    gateway=192.168.88.1 netmask=24
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip dhcp-server
add add-arp=yes address-pool=dhcp-pool1 bootp-lease-time=lease-time \
    bootp-support=dynamic disabled=no interface=LAN-Master lease-time=12h name=\
    dhcp-server1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip address
add address=192.168.88.1/24 comment="Local" interface=LAN-Master network=192.168.88.0
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system backup save name="initial_gtx300s_$"MODEL"bc_$"VER""
:log warning "CREATED_BACKUP_FILE_initial_gtx300s_$"MODEL"bc_$"VER""
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/file remove [ find type="directory" ]
/file remove [ find type="package" ]
/file remove [ find type=".fwf file" ]
/file remove [ find type=".rif file" ]
/file remove [ find type="web-proxy store" ]
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system routerboard upgrade
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system package disable [ find name=wireless ]
/system package disable [ find name=wireless-fp ]
/system package disable [ find name=wireless-cm2 ]
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

:log warning "SETTINGS_INSTALL_END";
/system reboot
:delay 1ms;