# Update 18.10.2018

/system logging action
set 1 disk-file-count=3
/system logging
set 0 action=memory prefix=INFO
set 1 action=memory prefix=ERR
set 2 action=disk prefix=WARN
set 3 action=memory prefix=CRIT
add action=memory prefix=SYN topics=async disabled=yes
:log warning "LOGGING_CHANGED"
:delay 3s

/system routerboard settings
set init-delay=5s
/system routerboard usb
set type=mini-PCIe
:log warning "MINI-PCI ACTIVATED"
:delay 1s

:log warning "SET INITIAL PARAMETER"
:global NUM 0
:global VER [:pick [/system resource get version] 0 4]
:global MODEL [:pick [/system routerboard get model] 0 3]
:global SERIAL [:pick [/system routerboard get serial-number] 7 12]

:log warning "SETTINGS_START_INSTALL"

/system identity
set name=GTX300-S-953BM2-WiFi
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ppp-client
set [ find name=ppp-out1 ] apn=internet comment="3G Internet" default-route-distance=1 \
    dial-on-demand=no disabled=no data-channel=2 info-channel=3 name=ppp-out1 port=usb2
set [ find name=ppp-out2 ] apn=internet default-route-distance=1 \
    dial-on-demand=no disabled=no data-channel=2 info-channel=3 name=ppp-out2 port=usb3
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1

/interface list
add name=WAN
/interface list member
add interface=ppp-out1 list=WAN
add interface=ppp-out2 list=WAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ethernet
set [ find default-name=ether1 ] mtu=1500 name="LAN1-eth"
set [ find default-name=ether2 ] mtu=1500 name="LAN2-eth"
set [ find default-name=ether3 ] mtu=1500 name="LAN3-eth"
set [ find default-name=sfp1 ] mtu=1500 name="LAN4-sfp"
set [ find default-name=sfp2 ] mtu=1500 name="LAN5-sfp"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface wireless security-profiles
add name=teleofis authentication-types=wpa2-psk eap-methods="" group-ciphers=aes-ccm \
    management-protection=allowed mode=dynamic-keys \
    supplicant-identity=TELEOFIS unicast-ciphers=aes-ccm \
    wpa2-pre-shared-key=11122233344455566677788899
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 2s

/interface wireless
set [ find default-name=wlan1 ] name="LAN6-wifi5ghz" antenna-gain=1 band=5ghz-a/n channel-width=\
    20/40mhz-Ce disabled=no distance=indoors frequency=auto guard-interval=long \
    hw-protection-mode=rts-cts mode=ap-bridge multicast-helper=full frequency-mode=regulatory-domain \
    rx-chains=0,1,2 security-profile=teleofis ssid=GTX300S-5GHZ tx-chains=0,1,2 country=russia \
    tx-power-mode=default wireless-protocol=802.11 radio-name="GTX300S953BM2$"SERIAL"" \
    wps-mode=disabled mtu=1500 wmm-support=enabled adaptive-noise-immunity=ap-and-client-mode
/interface wireless nstreme
set [find name="LAN6-wifi5ghz"] enable-polling=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

/ip firewall nat
add action=masquerade chain=srcnat comment="LAN to WAN" out-interface-list=WAN src-address=192.168.88.0/24
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge
add comment="LAN" name="LAN-Bridge" mtu=1500
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge port
add bridge="LAN-Bridge" comment="LAN" interface="LAN1-eth"
add bridge="LAN-Bridge" interface="LAN2-eth"
add bridge="LAN-Bridge" interface="LAN3-eth"
add bridge="LAN-Bridge" interface="LAN4-sfp"
add bridge="LAN-Bridge" interface="LAN5-sfp"
add bridge="LAN-Bridge" interface="LAN6-wifi5ghz"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface list
add name=LAN
/interface list member
add interface="LAN-Bridge" list=LAN comment="LAN"
add interface="LAN1-eth" list=LAN
add interface="LAN2-eth" list=LAN
add interface="LAN3-eth" list=LAN
add interface="LAN4-sfp" list=LAN
add interface="LAN5-sfp" list=LAN
add interface="LAN6-wifi5ghz" list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip neighbor discovery-settings
set discover-interface-list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dns
set allow-remote-requests=yes
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip firewall filter
add action=drop chain=input connection-state=invalid
add action=drop chain=forward connection-state=invalid
add action=accept chain=input in-interface-list=WAN protocol=udp src-port=53
add action=drop chain=input dst-port=53 in-interface-list=!LAN protocol=udp
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip firewall mangle
add action=mark-connection chain=prerouting comment="PREROUTING LAN" dst-address-type=!local in-interface=LAN-Bridge new-connection-mark=ppp-out1-in-conn passthrough=yes per-connection-classifier=both-addresses:2/0
add action=mark-routing chain=prerouting connection-mark=ppp-out1-in-conn dst-address-type=!local new-routing-mark=ppp-out1-out-route passthrough=no
add action=mark-connection chain=prerouting dst-address-type=!local in-interface=LAN-Bridge new-connection-mark=ppp-out2-in-conn passthrough=yes per-connection-classifier=both-addresses:2/1
add action=mark-routing chain=prerouting connection-mark=ppp-out2-in-conn dst-address-type=!local new-routing-mark=ppp-out2-out-route passthrough=no
add action=mark-connection chain=prerouting comment="PREROUTING WAN / OUTPUT WAN" in-interface=ppp-out1 new-connection-mark=ppp-out1-in-conn connection-state=new passthrough=yes
add action=mark-routing chain=output connection-mark=ppp-out1-in-conn new-routing-mark=ppp-out1-out-route passthrough=no
add action=mark-connection chain=prerouting in-interface=ppp-out2 new-connection-mark=ppp-out2-in-conn connection-state=new passthrough=yes
add action=mark-routing chain=output connection-mark=ppp-out2-in-conn new-routing-mark=ppp-out2-out-route passthrough=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip route
add distance=1 gateway=ppp-out1 routing-mark=ppp-out1-out-route
add distance=2 gateway=ppp-out2 routing-mark=ppp-out1-out-route
add distance=1 gateway=ppp-out2 routing-mark=ppp-out2-out-route
add distance=2 gateway=ppp-out1 routing-mark=ppp-out2-out-route
add distance=1 gateway=ppp-out1
add distance=2 gateway=ppp-out2
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system clock
set time-zone-autodetect=no time-zone-name=Europe/Moscow
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip cloud
set update-time=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system ntp client
set enabled=yes server-dns-names=\
    ntp4.stratum2.ru,ntp3.stratum2.ru,ntp5.stratum1.ru,timeserver.ru
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system note
set note="\
    \n  TTTTTTTT  EEEEEE  LL      EEEEEE    OOOO    FFFFFF  IIII   SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II   SS\
    \n     TT     EEEEEE  LL      EEEEEE  OO    OO  FFFFFF   II    SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II        SS\
    \n     TT     EEEEEE  LLLLLL  EEEEEE    OOOO    FF      IIII   SSSSS\
    \n\
    \n  Teleofis for MikroTik RouterOS $"VER" (c) 2004-2018  http://teleofis.ru/\
    \n  DO NOT UPDATE FIRMWARE:\
    \n  Stable operation of modules only on firmware $"VER"\
    \n\
    \n"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system scheduler
add comment="TELEOFIS Scripts" interval=15m name=watchdog on-event="# Script W\
    atchdog\r\
    \n# Connection validation script\r\
    \n# Company developer: TELEOFIS (tm) [https://teleofis.ru/]\r\
    \n#\r\
    \n\r\
    \n# Update IP addresses\r\
    \n:do {:set \$IP1 [:resolve yandex.ru]} on-error={:set \$IP1 77.88.8.8}\r\
    \n:do {:set \$IP2 [:resolve google.com]} on-error={:set \$IP2 8.8.8.8}\r\
    \n\r\
    \n# Init variables\r\
    \n:global IFACE1\r\
    \n:global IFACE2\r\
    \n:global IP1\r\
    \n:global IP2\r\
    \n:global ITER1 0\r\
    \n:global ITER2 0\r\
    \n:global PINGA1\r\
    \n:global PINGA2\r\
    \n:global PINGB1\r\
    \n:global PINGB2\r\
    \n:global ACTIFACE1\r\
    \n:global ACTIFACE2\r\
    \n\r\
    \n:set \$IFACE1 [:tostr [/interface ppp-client get 0 name]]\r\
    \n:set \$IFACE2 [:tostr [/interface ppp-client get 1 name]]\r\
    \n\r\
    \n# Start while checking\r\
    \n:while (true) do={\r\
    \n   \r\
    \n   # Check modems in ports\r\
    \n   :if ([/system resource usb print count-only where vendor!=\"Linux 3.3\
    .5 ehci_hcd\"] != 2) do={\r\
    \n      :log error \"watchdog: not found one or more mini-PCIe modems\"\r\
    \n      /system reboot\r\
    \n      :delay 1s\r\
    \n   }\r\
    \n   \r\
    \n   # Check act ppp-out1\r\
    \n   :if ([/interface ppp-client print count-only where name=\"ppp-out1\" disabled=ye\
    s] = 1) do={\r\
    \n      :log warning \"watchdog: \$\"IFACE1\" the interface is turned off.\
    \_Turn on the interface.\"\r\
    \n      /interface enable \$IFACE1\r\
    \n      :delay 15s\r\
    \n   }\r\
    \n   # Check act ppp-out2\r\
    \n   :if ([/interface ppp-client print count-only where name=\"ppp-out2\" disabled=ye\
    s] = 1) do={\r\
    \n      :log warning \"watchdog: \$\"IFACE2\" the interface is turned off.\
    \_Turn on the interface.\"\r\
    \n      /interface enable \$IFACE2\r\
    \n      :delay 15s\r\
    \n   }\r\
    \n   \r\
    \n   # Check ping first interface\r\
    \n   :set \$PINGA1 [ /ping count=10 interface=\$IFACE1 address=\$IP1 ]\r\
    \n   :if ( \$PINGA1 > 0 ) do={\r\
    \n      :log debug \"watchdog: PINGA1 \$\"IFACE1\" - ok\"\r\
    \n      :log debug \"watchdog: PINGA1 count = \$\"PINGA1\"\"\r\
    \n      :set \$ACTIFACE1 true\r\
    \n      :set \$ITER1 0\r\
    \n   } else={\r\
    \n      :log warning \"watchdog: PINGA1 \$\"IFACE1\" - no ping\"\r\
    \n      :set \$ACTIFACE1 false\r\
    \n   }\r\
    \n   :if ( \$ACTIFACE1 != true ) do={\r\
    \n      :set \$PINGA2 [ /ping count=10 interface=\$IFACE1 address=\$IP2 ]\
    \r\
    \n      :if ( \$PINGA2 > 0 ) do={\r\
    \n         :log debug \"watchdog: PINGA2 \$\"IFACE1\" - ok\"\r\
    \n         :log debug \"watchdog: PINGA2 count = \$\"PINGA2\"\"\r\
    \n         :set \$ACTIFACE1 true\r\
    \n         :set \$ITER1 0\r\
    \n      } else={\r\
    \n         :log warning \"watchdog: PINGA2 \$\"IFACE1\" - no ping\"\r\
    \n         :set \$ACTIFACE1 false\r\
    \n      }\r\
    \n   }\r\
    \n   \r\
    \n   # Check ping two interface\r\
    \n   :set \$PINGB1 [ /ping count=10 interface=\$IFACE2 address=\$IP1 ]\r\
    \n   :if ( \$PINGB1 > 0 ) do={\r\
    \n      :log debug \"watchdog: PINGB1 \$\"IFACE2\" - ok\"\r\
    \n      :log debug \"watchdog: PINGB1 count = \$\"PINGB1\"\"\r\
    \n      :set \$ACTIFACE2 true\r\
    \n      :set \$ITER2 0\r\
    \n   } else={\r\
    \n      :log warning \"watchdog: PINGB1 \$\"IFACE2\" - no ping\"\r\
    \n      :set \$ACTIFACE2 false\r\
    \n   }\r\
    \n   :if ( \$ACTIFACE2 != true ) do={\r\
    \n      :set \$PINGB2 [ /ping count=10 interface=\$IFACE2 address=\$IP2 ]\
    \r\
    \n      :if ( \$PINGB2 > 0 ) do={\r\
    \n         :log debug \"watchdog: PINGB2 \$\"IFACE2\" - ok\"\r\
    \n         :log debug \"watchdog: PINGB2 count = \$\"PINGB2\"\"\r\
    \n         :set \$ACTIFACE2 true\r\
    \n         :set \$ITER2 0\r\
    \n      } else={\r\
    \n         :log warning \"watchdog: PINGB2 \$\"IFACE2\" - no ping\"\r\
    \n         :set \$ACTIFACE2 false\r\
    \n      }\r\
    \n   }\r\
    \n   \r\
    \n   # All is good. Exit from while\r\
    \n   :if ( (\$ACTIFACE1 = true) && (\$ACTIFACE2 = true) ) do={\r\
    \n      :log info \"watchdog: Watchdog OK\"\r\
    \n      :quit;\r\
    \n   }\r\
    \n   \r\
    \n   # Next...\r\
    \n   # Check Iteration\r\
    \n   :if ( (\$ACTIFACE1 != true) && (\$ACTIFACE2 != true) && (\$ITER1 >= 2\
    ) && (\$ITER2 >= 2) ) do={\r\
    \n      :log error \"watchdog: No ping - connection down - Reboot!!!\"\r\
    \n      /system reboot\r\
    \n      :delay 120s\r\
    \n   }\r\
    \n   \r\
    \n   # First interface work, but no internet\r\
    \n   :if ( (\$ACTIFACE1 = false) && (\$ITER1 < 2)) do={\r\
    \n      :log warning \"watchdog: Reconnect \$\"IFACE1\"  interface\"\r\
    \n      /interface disable \$IFACE1\r\
    \n      :delay 15s\r\
    \n      /interface enable \$IFACE1\r\
    \n      :set \$ITER1 (\$ITER1+1)\r\
    \n      :log warning \"watchdog: Reconnect \$\"IFACE1\"  interface complet\
    e\"\r\
    \n   }\r\
    \n   :if (\$ITER1 >= 2) do={\r\
    \n      :log warning \"watchdog: No ping interface \$\"IFACE1\" - Resettin\
    g modem\"\r\
    \n      /system routerboard usb power-reset bus=1 duration=10\r\
    \n      :delay 30s\r\
    \n      :set \$ITER1 0\r\
    \n      :quit;\r\
    \n   }\r\
    \n   \r\
    \n   # Two interface work, but no internet\r\
    \n   :if ( (\$ACTIFACE2 = false) && (\$ITER2 < 2)) do={\r\
    \n      :log warning \"watchdog: Reconnect \$\"IFACE2\"  interface\"\r\
    \n      /interface disable \$IFACE2\r\
    \n      :delay 15s\r\
    \n      /interface enable \$IFACE2\r\
    \n      :set \$ITER2 (\$ITER2+1)\r\
    \n      :log warning \"watchdog: Reconnect \$\"IFACE2\"  interface - compl\
    ete\"\r\
    \n   }\r\
    \n   :if (\$ITER2 >= 2) do={\r\
    \n      :log warning \"watchdog: No ping interface \$\"IFACE2\" - Resettin\
    g modem\"\r\
    \n      /system routerboard usb power-reset bus=2 duration=10\r\
    \n      :delay 30s\r\
    \n      :set \$ITER2 0\r\
    \n      :quit;\r\
    \n   }\r\
    \n}\r\
    \n\r\
    \n# END" policy=\
    ftp,reboot,read,write,policy,test,password,sniff,sensitive start-time=\
    startup
add name=init on-event="# Script Init\r\
    \n# Initialisation variables\r\
    \n# Company developer: TELEOFIS (tm) [https://teleofis.ru/]\r\
    \n#\r\
    \n\r\
    \n:delay 20s\r\
    \n\r\
    \n# Variables\r\
    \n:global PINGA1 0\r\
    \n:global PINGA2 0\r\
    \n:global PINGB1 0\r\
    \n:global PINGB2 0\r\
    \n:global ACTIFACE1 false\r\
    \n:global ACTIFACE2 false\r\
    \n:global IFACE1 [:tostr [/interface ppp-client get 0 name]]\r\
    \n:global IFACE2 [:tostr [/interface ppp-client get 1 name]]\r\
    \n\r\
    \n# Update IP addresses\r\
    \n:do {:set \$IP1 [:resolve yandex.ru]} on-error={:set \$IP1 77.88.8.8}\r\
    \n:do {:set \$IP2 [:resolve google.com]} on-error={:set \$IP2 8.8.8.8}\r\
    \n\r\
    \n# END" policy=\
    ftp,reboot,read,write,policy,test,password,sniff,sensitive start-time=\
    startup
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

:global LEDSTATUS [/system leds find disabled=no]
:if ($LEDSTATUS != "") do={
/system leds
set 0 interface="LAN-Bridge" leds=user-led type=interface-transmit
add leds=led1,led2,led3,led4,led5 type=off
} else={
/system leds
add interface="LAN-Bridge" leds=user-led type=interface-transmit
add leds=led1,led2,led3,led4,led5 type=off
}
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip pool
add name=dhcp-pool1 ranges=192.168.88.10-192.168.88.250
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server network
add address=192.168.88.0/24 comment="For Local Bridge" dns-server=192.168.88.1 gateway=192.168.88.1 netmask=24
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server
add add-arp=yes address-pool=dhcp-pool1 bootp-lease-time=lease-time bootp-support=dynamic disabled=no interface="LAN-Bridge" lease-time=3d name=dhcp-server1
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip address
add address=192.168.88.1/24 comment="Local Bridge" interface="LAN-Bridge" network=192.168.88.0
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

:global GPS [/system package find name="gps"]
:if ($GPS != "") do={
   :log warning "GPS_ENABLE"
   /system gps
   set channel=1 enabled=yes port=usb3 set-system-time=no
   :set $NUM ($NUM+1)
   :log warning "STEP_$"NUM"_COMPLETE"
   :delay 1s
}

/system backup
save name="initial_gtx300swf_$"MODEL"bm2_$"VER""
:log warning "CREATED_BACKUP_FILE_initial_gtx300swf_$"MODEL"bm2_$"VER"";
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/file
remove [ find type="directory" ]
remove [ find type="package" ]
remove [ find type=".fwf file" ]
remove [ find type=".rif file" ]
remove [ find type="web-proxy store" ]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system routerboard upgrade
:delay 0s
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

:log warning "SETTINGS_INSTALL_END"
:log warning "REBOOT"
/system reboot
:delay 0s