# Update 28.08.2018

/system logging action
set 1 disk-file-count=3
/system logging
set 0 action=memory prefix=INFO
set 1 action=memory prefix=ERR
set 2 action=disk prefix=WARN
set 3 action=memory prefix=CRIT
add action=memory prefix=SYN topics=async disabled=yes
:log warning "LOGGING_CHANGED"
:delay 3s

/system routerboard settings
set init-delay=5s
/system routerboard usb
set type=mini-PCIe
:log warning "MINI-PCI ACTIVATED"
:delay 1s

:log warning "SET INITIAL PARAMETER"
:global NUM 0
:global VER [:pick [/system resource get version] 0 4]
:global MODEL [:pick [/system routerboard get model] 0 3]
:global SERIAL [:pick [/system routerboard get serial-number] 7 12]

:log warning "SETTINGS_START_INSTALL"

/system identity
set name=GTX400-953BM-WiFi
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ppp-client
remove [find name="ppp-out1"]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface lte
set [find name="lte1"] comment="WAN"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface list
add name=WAN
/interface list member
add interface=lte1 list=WAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ethernet
set [ find default-name=ether1 ] mtu=1500 name="LAN1-eth"
set [ find default-name=ether2 ] mtu=1500 name="LAN2-eth"
set [ find default-name=ether3 ] mtu=1500 name="LAN3-eth"
set [ find default-name=sfp1 ] mtu=1500 name="LAN4-sfp"
set [ find default-name=sfp2 ] mtu=1500 name="LAN5-sfp"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface wireless security-profiles
add name=teleofis authentication-types=wpa2-psk eap-methods="" group-ciphers=aes-ccm \
    management-protection=allowed mode=dynamic-keys \
    supplicant-identity=TELEOFIS unicast-ciphers=aes-ccm \
    wpa2-pre-shared-key=11122233344455566677788899
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 2s

/interface wireless
set [ find default-name=wlan1 ] name="LAN6-wifi5ghz" antenna-gain=1 band=5ghz-a/n channel-width=\
    20/40mhz-Ce disabled=no distance=indoors frequency=auto guard-interval=long \
    hw-protection-mode=rts-cts mode=ap-bridge multicast-helper=full frequency-mode=regulatory-domain \
    rx-chains=0,1,2 security-profile=teleofis ssid=GTX400-5GHz tx-chains=0,1,2 country=russia \
    tx-power-mode=default wireless-protocol=802.11 radio-name="GTX400953BM$"SERIAL"" \
    wps-mode=disabled mtu=1500 wmm-support=enabled adaptive-noise-immunity=ap-and-client-mode
/interface wireless nstreme
set [find name="LAN6-wifi5ghz"] enable-polling=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

/ip firewall nat
add action=masquerade chain=srcnat comment="LAN to WAN" out-interface-list=WAN src-address=192.168.88.0/24
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge
add comment="LAN" name="LAN-Bridge" mtu=1500
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge port
add bridge="LAN-Bridge" comment="LAN" interface="LAN1-eth"
add bridge="LAN-Bridge" interface="LAN2-eth"
add bridge="LAN-Bridge" interface="LAN3-eth"
add bridge="LAN-Bridge" interface="LAN4-sfp"
add bridge="LAN-Bridge" interface="LAN5-sfp"
add bridge="LAN-Bridge" interface="LAN6-wifi5ghz"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface list
add name=LAN
/interface list member
add interface="LAN-Bridge" list=LAN comment="LAN"
add interface="LAN1-eth" list=LAN
add interface="LAN2-eth" list=LAN
add interface="LAN3-eth" list=LAN
add interface="LAN4-sfp" list=LAN
add interface="LAN5-sfp" list=LAN
add interface="LAN6-wifi5ghz" list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip neighbor discovery-settings
set discover-interface-list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dns
set allow-remote-requests=yes
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip firewall filter
add action=drop chain=input connection-state=invalid
add action=drop chain=forward connection-state=invalid
add action=accept chain=input in-interface-list=WAN protocol=udp src-port=53
add action=drop chain=input dst-port=53 in-interface-list=!LAN protocol=udp
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system clock
set time-zone-autodetect=no time-zone-name=Europe/Moscow
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip cloud
set update-time=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system ntp client
set enabled=yes server-dns-names=\
    ntp4.stratum2.ru,ntp3.stratum2.ru,ntp5.stratum1.ru,timeserver.ru
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system note
set note="\
    \n  TTTTTTTT  EEEEEE  LL      EEEEEE    OOOO    FFFFFF  IIII   SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II   SS\
    \n     TT     EEEEEE  LL      EEEEEE  OO    OO  FFFFFF   II    SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II        SS\
    \n     TT     EEEEEE  LLLLLL  EEEEEE    OOOO    FF      IIII   SSSSS\
    \n\
    \n  Teleofis for MikroTik RouterOS $"VER" (c) 2004-2018  http://teleofis.ru/\
    \n  DO NOT UPDATE FIRMWARE:\
    \n  Stable operation of modules only on firmware $"VER"\
    \n\
    \n"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system scheduler
add comment="TELEOFIS Scripts" interval=10m name=watchdog on-event="# Script W\
    atchdog\r\
    \n# Connection validation script\r\
    \n# Company developer: TELEOFIS (tm) [https://teleofis.ru/]\r\
    \n#\r\
    \n\r\
    \n# Update IP addresses\r\
    \n:do {\r\
    \n   :set \$IP1 [:resolve yandex.ru]\r\
    \n} on-error={\r\
    \n   :set \$IP1 \"77.88.8.8\"\r\
    \n}\r\
    \n:do {\r\
    \n   :set \$IP2 [:resolve google.com]\r\
    \n} on-error={\r\
    \n   :set \$IP2 \"8.8.8.8\"\r\
    \n}\r\
    \n\r\
    \n# Start while checking\r\
    \n:while (true) do={\r\
    \n\r\
    \n   # Check ports\
    \n\r\
    \n   :if ([/port print count-only where device!=\"\"] < 1 ) do={\
    \n\r\
    \n      :log warning \"watchdog:  The number of modems does not match the \
    specified. Reboot...\"\r\
    \n      /system reboot\r\
    \n   }\r\
    \n\r\
    \n   # Check port channels\r\
    \n   :if ([/port get [find name=usb2] channels] != 1) do={\
    \n\r\
    \n      :log warning \"watchdog:  \$\"IFACE\" Invalid Number of Channels. \
    Modem power reset...\"\r\
    \n      /system reboot\r\
    \n   }\r\
    \n\r\
    \n   # Check LTE Interface Active\r\
    \n   :if ([/interface lte get \$IFACE disabled] != false) do={\r\
    \n      :log warning \"watchdog: LTE interface disabled. Enable...\"\r\
    \n      /interface lte enable \$IFACE\r\
    \n      :delay 20s\
    \n\r\
    \n   }\r\
    \n\r\
    \n   # Check connection\r\
    \n   :set \$PING1 [/ping count=10 interface=\$IFACE address=\$IP1]\
    \n\r\
    \n   :if (\$PING1 > 8) do={\r\
    \n      :set \$ITER 0\r\
    \n      :quit;\r\
    \n   } else={\r\
    \n      :log warning \"watchdog: PING1 Error - count \$\"PING1\"\"\r\
    \n   }\r\
    \n   :set \$PING2 [/ping count=10 interface=\$IFACE address=\$IP2]\r\
    \n   :if (\$PING2 > 8) do={\r\
    \n      :set \$ITER 0\r\
    \n      :quit;\r\
    \n   } else={\r\
    \n      :log warning \"watchdog: PING2 Error - count \$\"PING2\"\"\r\
    \n   }\
    \n\r\
    \n\r\
    \n   # Cycle result\r\
    \n   # Makes three checks\r\
    \n   :if (\$ITER < 2) do={\
    \n\r\
    \n      :set \$ITER (\$ITER+1)\r\
    \n      :log warning \"watchdog: Iteration \$\"ITER\" - Reconnect...\"\r\
    \n      /interface lte disable \$IFACE\r\
    \n      :delay 5s\r\
    \n      /interface lte enable \$IFACE\r\
    \n      :delay 20s\r\
    \n   } else={\r\
    \n      :set \$ITER (\$ITER+1)\r\
    \n      :log warning \"watchdog: Iteration \$\"ITER\" - Number of reconnec\
    tions exhausted. Reboot!\"\r\
    \n      :delay 3s\r\
    \n      /system reboot\r\
    \n   }\
    \n\r\
    \n}\r\
    \n\r\
    \n# END" policy=\
    ftp,reboot,read,write,policy,test,password,sniff,sensitive start-time=\
    startup
add name=init on-event="# Script Init\r\
    \n# Initialisation variables\r\
    \n# Company developer: TELEOFIS (tm) [https://teleofis.ru/]\r\
    \n#\r\
    \n\r\
    \n:delay 20s\r\
    \n\r\
    \n# Getting name LTE interface\r\
    \n:global IFACE [:tostr [/interface lte get 0 name]]\r\
    \n\r\
    \n# Update IP addresses\r\
    \n:do {\r\
    \n   :global IP1 [:resolve yandex.ru]\r\
    \n} on-error={\r\
    \n   :global IP1 \"77.88.8.8\"\r\
    \n}\r\
    \n:do {\r\
    \n   :global IP2 [:resolve google.com]\r\
    \n} on-error={\r\
    \n   :global IP2 \"8.8.8.8\"\r\
    \n}\r\
    \n\r\
    \n# Variables\r\
    \n:global ITER 0\r\
    \n:global PING1 0\r\
    \n:global PING2 0\r\
    \n\r\
    \n# END" policy=\
    ftp,reboot,read,write,policy,test,password,sniff,sensitive,romon \
    start-time=startup
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

:global LEDSTATUS [/system leds find disabled=no]
:if ($LEDSTATUS != "") do={
/system leds
set 0 interface="LAN-Bridge" leds=user-led type=interface-transmit
add leds=led1,led2,led3,led4,led5 type=off
} else={
/system leds
add interface="LAN-Bridge" leds=user-led type=interface-transmit
add leds=led1,led2,led3,led4,led5 type=off
}
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip pool
add name=dhcp-pool1 ranges=192.168.88.10-192.168.88.250
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server network
add address=192.168.88.0/24 comment="For Local Bridge" dns-server=192.168.88.1 gateway=192.168.88.1 netmask=24
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server
add add-arp=yes address-pool=dhcp-pool1 bootp-lease-time=lease-time bootp-support=dynamic disabled=no interface="LAN-Bridge" lease-time=3d name=dhcp-server1
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip address
add address=192.168.88.1/24 comment="Local Bridge" interface="LAN-Bridge" network=192.168.88.0
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

:if ([/system package print count-only where name="gps"] = 1) do={
   :log warning "GPS_ENABLE"
   /system gps
   set channel=0 enabled=yes port=usb2 set-system-time=no
   :set $NUM ($NUM+1)
   :log warning "STEP_$"NUM"_COMPLETE"
   :delay 1s
}

/system backup
save name="initial_gtx400wf_$"MODEL"bm_$"VER""
:log warning "CREATED_BACKUP_FILE_initial_gtx400wf_$"MODEL"bm_$"VER"";
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/file
remove [ find type="directory" ]
remove [ find type="package" ]
remove [ find type=".fwf file" ]
remove [ find type=".rif file" ]
remove [ find type="web-proxy store" ]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system routerboard upgrade
:delay 0s
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

:log warning "SETTINGS_INSTALL_END"
:log warning "REBOOT"
/system reboot
:delay 0s