/system logging action
set 1 disk-file-count=3
/system logging
set 0 action=memory prefix=INFO
set 1 action=disk prefix=ERR
set 2 action=disk prefix=WARN
set 3 action=memory prefix=CRIT
add action=memory prefix=SYN topics=async disabled=yes
:log warning "LOGGING_CHANGED";
:delay 3;

/ip cloud
set update-time=no

/system routerboard settings set cpu-frequency=600MHz init-delay=0s
/system routerboard usb set type=mini-PCIe
:log warning "CPU FREQ SET / MINI-PCI ACTIVATED";

:log warning "SET INITIAL PARAMETER";
:global NUM 0;
:global VER [:pick [/system resource get version] 0 4];
:global MODEL [:pick [/system routerboard get model] 0 3];

:log warning "SETTINGS_START_INSTALL";

/system identity set name=GTX300-S-912GM-WiFi
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1;

/interface ppp-client
set [ find name=ppp-out1 ] apn=internet comment="3G Internet" default-route-distance=1 \
    dial-on-demand=no disabled=yes data-channel=2 info-channel=3 name=ppp-out1 port=usb1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/interface ethernet set [ find default-name=ether1 ] comment="LAN" mtu=1500
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/interface ppp-client
set [ find name=ppp-out1 ] disabled=no
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 10s;

/interface bridge add comment="WLAN + LAN" name=bridge1 mtu=1500
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/interface wireless security-profiles
set [ find default=yes ] authentication-types=wpa2-psk eap-methods="" group-ciphers=aes-ccm \
    management-protection=allowed mode=dynamic-keys \
    supplicant-identity=TELEOFIS unicast-ciphers=aes-ccm \
    wpa2-pre-shared-key=11122233344455566677788899
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 2s;

/interface wireless
set [ find default-name=wlan1 ] antenna-gain=1 band=2ghz-b/g/n channel-width=\
    20/40mhz-Ce comment=WLAN disabled=no distance=indoors frequency=auto \
    hw-protection-mode=rts-cts mode=ap-bridge multicast-helper=disabled \
    rx-chains=0,1 security-profile=default ssid=GTX300S tx-chains=0,1 \
    tx-power-mode=default country=russia wireless-protocol=802.11 \
    wps-mode=disabled mtu=1500 wmm-support=enabled frequency-mode=regulatory-domain
/interface wireless manual-tx-power-table set [ find name=wlan1 ] comment="WLAN"
/interface wireless nstreme set [ find name=wlan1 ] comment="WLAN" enable-polling=no
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 5s;

/interface bridge port
add bridge=bridge1 comment="LAN" interface=ether1
add bridge=bridge1 comment="WLAN" interface=wlan1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip dns
set allow-remote-requests=yes
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system clock
set time-zone-autodetect=no time-zone-name=Europe/Moscow
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system ntp client
set enabled=yes server-dns-names=\
    ntp4.stratum2.ru,ntp3.stratum2.ru,ntp5.stratum1.ru,timeserver.ru
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system note
set note="\
    \n  TTTTTTTT  EEEEEE  LL      EEEEEE    OOOO    FFFFFF  IIII   SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II   SS\
    \n     TT     EEEEEE  LL      EEEEEE  OO    OO  FFFFFF   II    SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II        SS\
    \n     TT     EEEEEE  LLLLLL  EEEEEE    OOOO    FF      IIII   SSSSS\
    \n\
    \n  Teleofis for MikroTik RouterOS $"VER" (c) 2004-2017  http://teleofis.ru/\
    \n\
    \n"
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system scheduler
add disabled=no interval=10m name="watchdog" on-event=":global ITERATION 0;\r\
    \n:global IP1 8.8.8.8;\r\
    \n:global IP2 8.8.4.4;\r\
    \n:log debug \"watchdog: Start Watchdog\";\r\
    \n:while (true) do={\r\
    \n   :if ([:len [/system resource usb find]] < 2) do={\r\
    \n      :log error \"watchdog: Could not Find Modem Card - REBOOT\";\r\
    \n      :delay 5s;\r\
    \n      /system reboot;\r\
    \n      :delay 1s;\r\
    \n   }\r\
    \n   :if ([/port get number=0 channel] != 5) do={\r\
    \n      :log error \"watchdog: Invalid Number of Channels - REBOOT\";\r\
    \n      :delay 5s;\r\
    \n      /system reboot;\r\
    \n      :delay 1s;\r\
    \n   }\r\
    \n   :if ([/port find inactive=no] != \"\") do={\r\
    \n      :global PING1 [/ping \$IP1 count=10];\r\
    \n      :if (\$PING1 > 5) do={\r\
    \n         :log debug \"watchdog: Ping 1 Watchdog - OK\";\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :global PING2 [/ping \$IP2 count=10];\r\
    \n      :if (\$PING2 > 5) do={\r\
    \n         :log debug \"watchdog: Ping 2 Watchdog - OK\";\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :if (\$ITERATION < 3) do={\r\
    \n         :log warning \"watchdog: Could not Ping - RECONNECT\";\r\
    \n         /system routerboard usb power-reset duration=3;\r\
    \n         :set \$ITERATION (\$ITERATION+1);\r\
    \n         :delay 60s;\r\
    \n      } else={\r\
    \n         :log error \"watchdog: Could not Ping - REBOOT\";\r\
    \n         /system routerboard usb power-reset duration=3;\r\
    \n         :delay 5s;\r\
    \n         /system reboot;\r\
    \n         :delay 1s;\r\
    \n      }\r\
    \n   } else={\r\
    \n      :log error \"watchdog: Could not Find Port - REBOOT\";\r\
    \n      :delay 5s;\r\
    \n      /system reboot;\r\
    \n      :delay 1s;\r\
    \n   }\r\
    \n}" policy=ftp,reboot,read,write,policy,test,password,sniff,sensitive \
    start-time=startup
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 5s;

:global LEDSTATUS [/system leds find disabled=no];
:if ($LEDSTATUS != "") do={
/system leds
set 0 interface=ppp-out1 leds=user-led type=interface-transmit
add interface=ppp-out1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 \
    type=modem-signal
} else={
/system leds
add interface=ppp-out1 leds=user-led type=interface-transmit
add interface=ppp-out1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 \
    type=modem-signal
}
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 5s;

/ip pool add name=dhcp-pool1 ranges=192.168.88.10-192.168.88.250
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip dhcp-server network
add address=192.168.88.0/24 comment="For WLAN + LAN Bridge" dns-server=\
    192.168.88.1 gateway=192.168.88.1 netmask=24
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip dhcp-server
add add-arp=yes address-pool=dhcp-pool1 bootp-lease-time=lease-time \
    bootp-support=dynamic disabled=no interface=bridge1 lease-time=3d name=\
    dhcp-server1
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip address
add address=192.168.88.1/24 comment="WLAN + LAN" interface=bridge1 network=\
    192.168.88.0
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/ip firewall nat
add action=masquerade chain=srcnat comment="Internet To WLAN+LAN Bridge" \
    log-prefix="" out-interface=ppp-out1
/ip firewall filter
add action=drop chain=input connection-state=invalid
add action=drop chain=forward connection-state=invalid
add action=accept chain=input connection-state=established,related
add action=accept chain=forward connection-state=established,related
add action=accept chain=input in-interface=ppp-out1 protocol=udp src-port=53
add action=drop chain=input dst-port=53 in-interface=!bridge1 protocol=udp
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

:if ([:len [/system package find name=gps]] > 0) do={
   /system gps
   set channel=1 enabled=yes init-string="" port=usb1 set-system-time=yes
   :set $NUM ($NUM+1)
   :log warning "STEP_$"NUM"_COMPLETE"
   :delay 1s
}

/system backup save name="initial_gtx300swf_$"MODEL"gm_$"VER""
/log warning "CREATED_BACKUP_FILE_initial_gtx300swf_$"MODEL"gm_$"VER""
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 2s;

/file remove [ find type="directory" ]
/file remove [ find type="package" ]
/file remove [ find type=".fwf file" ]
/file remove [ find type=".rif file" ]
/file remove [ find type="web-proxy store" ]
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/system routerboard upgrade
:set $NUM ($NUM+1);
:log warning "STEP_$"NUM"_COMPLETE";
:delay 1s;

/log warning "SETTINGS_INSTALL_END"
/log warning "REBOOT"
/system reboot
:delay 1s;