# Update 30.01.2019 v2

/system logging action
set 1 disk-file-count=3
/system logging
set 0 action=memory prefix=INFO
set 1 action=disk prefix=ERR
set 2 action=disk prefix=WARN
set 3 action=memory prefix=CRIT
add action=memory prefix=SYN topics=async disabled=yes
:log warning "LOGGING_CHANGED"
:delay 3s

/system routerboard settings
set cpu-frequency=600MHz init-delay=5s
/system routerboard usb
set type=mini-PCIe
:log warning "CPU FREQ SET / MINI-PCI ACTIVATED"

:log warning "SET INITIAL PARAMETER"
:global NUM 0
:global VER [:pick [/system resource get version] 0 4]
:global MODEL [:pick [/system routerboard get model] 0 3]

:log warning "SETTINGS_START_INSTALL"

/system identity
set name=GTX400-912BC
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ppp-client
remove [find name="ppp-out1"]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface lte
set [find name="lte1"] comment="WAN"
/interface lte apn
set [find name="default"] default-route-distance=1
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface ethernet
set [ find default-name=ether1 ] name="LAN1-Master" mtu=1500
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge
add comment="LAN" name="LAN-Bridge" mtu=1500
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface bridge port
add bridge=LAN-Bridge comment="LAN" interface=LAN1-Master
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/interface list
add name=WAN
add name=LAN
/interface list member
add interface=lte1 list=WAN
add interface=LAN-Bridge list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip firewall nat
add action=masquerade chain=srcnat comment="LAN to WAN" out-interface-list=WAN
/ip firewall filter
add action=accept chain=input connection-state=established,related
add action=accept chain=input in-interface-list=WAN protocol=udp src-port=53
add action=drop chain=input dst-port=53 in-interface-list=WAN protocol=udp
add action=drop chain=input connection-state=invalid
add action=accept chain=forward connection-state=established,related
add action=drop chain=forward connection-state=invalid
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip neighbor discovery-settings
set discover-interface-list=LAN
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dns
set allow-remote-requests=yes
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system clock
set time-zone-autodetect=no time-zone-name=Europe/Moscow
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip cloud
set update-time=no
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system ntp client
set enabled=yes server-dns-names=\
    ntp4.stratum2.ru,ntp3.stratum2.ru,ntp5.stratum1.ru,timeserver.ru
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system note
set note="\
    \n  TTTTTTTT  EEEEEE  LL      EEEEEE    OOOO    FFFFFF  IIII   SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II   SS\
    \n     TT     EEEEEE  LL      EEEEEE  OO    OO  FFFFFF   II    SSSSS\
    \n     TT     EE      LL      EE       OO  OO   FF       II        SS\
    \n     TT     EEEEEE  LLLLLL  EEEEEE    OOOO    FF      IIII   SSSSS\
    \n\
    \n  Teleofis for MikroTik RouterOS $"VER" (c) 2004-2019  http://teleofis.ru/\
    \n\
    \n"
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system scheduler
add interval=10m name=watchdog on-event=":global ITERATION 0\r\
    \n:global IP1\r\
    \n:global IP2\r\
    \n\r\
    \n:do {\r\
    \n   :set \$IP1 [:resolve yandex.ru]\r\
    \n} on-error={\r\
    \n   :set \$IP1 77.88.8.8\r\
    \n}\r\
    \n:do {\r\
    \n   :set \$IP2 [:resolve google.com]\r\
    \n} on-error={\r\
    \n   :set \$IP2 8.8.8.8\r\
    \n}\r\
    \n\r\
    \n:while (true) do={\r\
    \n   :if ([:len [/system resource usb find]] < 2) do={\r\
    \n      :log error \"watchdog: Could not Find Modem Card - REBOOT\"\r\
    \n      :delay 5s\r\
    \n      /system reboot\r\
    \n      :delay 0s\r\
    \n   }\r\
    \n   :if ([/port get number=0 channel] != 1) do={\r\
    \n      :log error \"watchdog: Invalid Number of Channels - REBOOT\"\r\
    \n      :delay 5s\r\
    \n      /system reboot\r\
    \n      :delay 0s\r\
    \n   }\r\
    \n   :if ([/port find inactive=no] != \"\") do={\r\
    \n      :global PING1 [/ping \$IP1 count=10]\r\
    \n      :if (\$PING1 > 8) do={\r\
    \n         :log info \"watchdog: Ping 1 Watchdog - OK\"\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :global PING2 [/ping \$IP2 count=10];\r\
    \n      :if (\$PING2 > 8) do={\r\
    \n         :log info \"watchdog: Ping 2 Watchdog - OK\"\r\
    \n         :quit;\r\
    \n      }\r\
    \n      :if (\$ITERATION < 3) do={\r\
    \n         :log warning \"watchdog: Could not Ping - RECONNECT LTE\"\r\
    \n         /interface lte set 0 disabled=yes\r\
    \n         :delay 5s\r\
    \n         /interface lte set 0 disabled=no\r\
    \n         :set \$ITERATION (\$ITERATION+1)\r\
    \n         :delay 60s\r\
    \n      } else={\r\
    \n         :log error \"watchdog: Could not Ping - REBOOT\"\r\
    \n         :delay 5s\r\
    \n         /system reboot\r\
    \n         :delay 0s\r\
    \n      }\r\
    \n   } else={\r\
    \n      :log error \"watchdog: Could not Find Port - REBOOT\"\r\
    \n      :delay 5s\r\
    \n      /system reboot\r\
    \n      :delay 0s\r\
    \n   }\r\
    \n}" policy=ftp,reboot,read,write,policy,test,password,sniff,sensitive start-time=startup
add name=lte_registered on-event=":delay 20s\r\
    \n:log info \"lte_registered: start registered...\"\r\
    \n/interface lte at-chat 0 input=\"AT+CFUN=0\" wait=yes\r\
    \n:delay 2s\r\
    \n/interface lte at-chat 0 input=\"AT+CFUN=1\"" policy=ftp,reboot,read,write,policy,test,password,sniff,sensitive,romon \
    start-time=startup
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

:global LEDSTATUS [/system leds find disabled=no];
:if ($LEDSTATUS != "") do={
/system leds
set 0 interface=lte1 leds=user-led type=interface-transmit
add interface=lte1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 type=modem-signal
} else={
/system leds
add interface=lte1 leds=user-led type=interface-transmit
add interface=lte1 leds=led1,led2,led3,led4,led5 modem-signal-treshold=-105 type=modem-signal
}
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 5s

/ip pool
add name=dhcp-pool1 ranges=192.168.88.10-192.168.88.250
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server network
add address=192.168.88.0/24 comment="For LAN" dns-server=192.168.88.1 gateway=192.168.88.1 netmask=24
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip address
add address=192.168.88.1/24 comment="LAN" interface=LAN-Bridge network=192.168.88.0
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/ip dhcp-server
add add-arp=yes address-pool=dhcp-pool1 bootp-lease-time=lease-time \
    bootp-support=dynamic disabled=no interface=LAN-Bridge lease-time=3d name=\
    dhcp-server1
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system backup
save name="initial_gtx400_$"MODEL"bc_$"VER""
:log warning "CREATED_BACKUP_FILE_initial_gtx400_$"MODEL"bc_$"VER""
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 2s

/file
remove [ find type="directory" ]
remove [ find type="package" ]
remove [ find type=".fwf file" ]
remove [ find type=".rif file" ]
remove [ find type="web-proxy store" ]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system routerboard upgrade
:delay 0s
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

/system package disable [ find name=wireless ]
:set $NUM ($NUM+1)
:log warning "STEP_$"NUM"_COMPLETE"
:delay 1s

:log warning "SETTINGS_INSTALL_END"
:log warning "REBOOT"
/system reboot
:delay 0s