'''
Copyright (c) 2013, ОАО "ТЕЛЕОФИС"

Разрешается повторное распространение и использование как в виде исходного кода, так и в двоичной форме, 
с изменениями или без, при соблюдении следующих условий:

- При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
  этот список условий и последующий отказ от гарантий.
- При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
  этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых 
  при распространении.
- Ни название ОАО "ТЕЛЕОФИС", ни имена ее сотрудников не могут быть использованы в качестве поддержки или 
  продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.

ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» БЕЗ КАКОГО-ЛИБО 
ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ 
КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ 
ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ 
НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ 
ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ 
ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ 
РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О 
ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
'''

import sys, MDM, MOD, GPIO

########################################################
# Constants
########################################################
NETWORK_WAIT_TIME = 120     # in seconds
SIM2_WORK_TIME = 300       # in seconds
MAIN_LOOP_PERIOD = 5        # in seconds

WATCHDOG_ENABLE = 1        # 0 - disabled, 1 - enabled
WATCHDOG_TIME = 60         # in seconds

########################################################
# Functions
########################################################
def send(data):
    MDM.send(data + '\r', 2)

def receive(timeout = 2):
    data = ''
    timer = MOD.secCounter() + timeout
    while(MOD.secCounter() < timer):
        rcv = MDM.read()
        if(len(rcv) > 0):
            data = data + rcv
            if(data.endswith('\r') or data.endswith('\n')):
                break
    return data

def reboot():
    send('AT#ENHRST=1,0')
    sys.exit()

def checkCREG():
    send('AT+CREG?')
    res = receive()
    if(res.find('+CREG: 0,1') != -1):
        return 0
    return -1

def checkCSQ():
    send('AT+CSQ')
    res = receive()
    pos = res.find('+CSQ:')
    if(pos != -1):
        val = int(res[pos+6:].strip().split(',')[0])
        return val
    return -1

def initWatchdog():
    if(WATCHDOG_ENABLE):
        MOD.watchdogEnable(WATCHDOG_TIME)
    
def resetWatchdog():
    if(WATCHDOG_ENABLE):
        MOD.watchdogReset()
    
def initGPIO():
    GPIO.setIOdir(1, 0, 1) # SIM Card
    
def enableSIM(sim):
    send('AT#SIMDET=0')
    MOD.sleep(20)
    GPIO.setIOvalue(1, sim)
    send('AT#SIMDET=1')
    MOD.sleep(50)
    
def initRING():
    send('AT\\R0')
    

########################################################
# Main loop
########################################################
try:
    initWatchdog()
    initGPIO()
    initRING()
    
    timer = MOD.secCounter() + NETWORK_WAIT_TIME
    sim2timer = 0
    activeSim = 0
    
    while(1):
        print 'Live...\r\n'
        resetWatchdog()
        ri = MDM.getRI()
        if(ri == 1):
            print 'Incoming connection\r\n'
            MOD.sleep(MAIN_LOOP_PERIOD * 10)
            continue
        creg = checkCREG()
        if(creg == 0):
            csq = checkCSQ()
            print 'CSQ: %d\r\n' % (csq)
            if(csq > 12):
                if(activeSim == 1):
                    if(MOD.secCounter() > sim2timer):
                        print 'SIM2_WORK_TIME timeout, switching to SIM1\r\n'
                        activeSim = 0
                        enableSIM(activeSim)
                timer = MOD.secCounter() + NETWORK_WAIT_TIME
        if(MOD.secCounter() > timer):
            print 'NETWORK_WAIT_TIME timeout'
            if(activeSim == 0):
                print 'Switch to SIM2'
                activeSim = 1
                enableSIM(activeSim)
                sim2timer = MOD.secCounter() + SIM2_WORK_TIME
            else:
                print 'Switch to SIM1'
                activeSim = 0
                enableSIM(activeSim)
            timer = MOD.secCounter() + NETWORK_WAIT_TIME
        MOD.sleep(MAIN_LOOP_PERIOD * 10)
            
except Exception, e:
    reboot()
    