'''
Copyright (c) 2013, ОАО "ТЕЛЕОФИС"

Разрешается повторное распространение и использование как в виде исходного кода, так и в двоичной форме, 
с изменениями или без, при соблюдении следующих условий:

- При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
  этот список условий и последующий отказ от гарантий.
- При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
  этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых 
  при распространении.
- Ни название ОАО "ТЕЛЕОФИС", ни имена ее сотрудников не могут быть использованы в качестве поддержки или 
  продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.

ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» БЕЗ КАКОГО-ЛИБО 
ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ 
КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ 
ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ 
НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ 
ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ 
ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ 
РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О 
ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
'''

import sys, MDM, MOD, GPIO

import config
CONFIG = config.Config()
CONFIG.read()

########################################################
# Constants
########################################################
MAIN_LOOP_PERIOD = int(CONFIG.get('MAIN_LOOP_PERIOD'))

WATCHDOG_ENABLE = int(CONFIG.get('WATCHDOG_ENABLE'))
WATCHDOG_TIME = int(CONFIG.get('WATCHDOG_TIME'))

GPRS1_APN = CONFIG.get('GPRS1_APN')
GPRS1_USER = CONFIG.get('GPRS1_USER')
GPRS1_PASSWORD = CONFIG.get('GPRS1_PASSWORD')

GPRS2_APN = CONFIG.get('GPRS2_APN')
GPRS2_USER = CONFIG.get('GPRS2_USER')
GPRS2_PASSWORD = CONFIG.get('GPRS2_PASSWORD')

PING_HOST = CONFIG.get('PING_HOST')
PING_PORT = CONFIG.get('PING_PORT')

MAX_REGISTER_FAILS = int(CONFIG.get('MAX_REGISTER_FAILS'))
MAX_CONTEXT_FAILS = int(CONFIG.get('MAX_CONTEXT_FAILS'))
MAX_PING_FAILS = int(CONFIG.get('MAX_PING_FAILS'))

RESULT_OK = 0

########################################################
# Functions
########################################################

def debug(msg):
    print str(MOD.secCounter()) + " - " + msg

def exchange(output, input, timeout):
    MDM.send(output + '\r', 2)
    timer = MOD.secCounter() + timeout
    rcv = ''
    res = -1
    while(MOD.secCounter() < timer):
        rcv = rcv + MDM.read()
        if(rcv.find(input) != -1):
            res = 0
            break
    return (res, rcv)
    
def reboot():
    a, s = exchange('AT#ENHRST=1,0', 'OK', 2)

def checkCREG():
    a, s = exchange('AT+CREG?', 'OK', 2)
    if(s.find('+CREG: 0,1') != -1):
        return 0
    return -1

def checkCSQ():
    a, s = exchange('AT+CSQ', 'OK', 2)
    pos = s.find('+CSQ:')
    if(pos != -1):
        val = int(s[pos+6:].strip().split(',')[0])
        return val
    return -1

def initWatchdog():
    if(WATCHDOG_ENABLE):
        MOD.watchdogEnable(WATCHDOG_TIME)
    
def resetWatchdog():
    if(WATCHDOG_ENABLE):
        MOD.watchdogReset()
    
def initGPIO():
    GPIO.setIOdir(1, 0, 1) # SIM Card
    
def enableSIM(sim):
    GPIO.setIOvalue(1, sim)
    a, s = exchange('AT#SIMDET=0', 'OK', 2)
    MOD.sleep(50)
    a, s = exchange('AT#SIMDET=1', 'OK', 2)
    MOD.sleep(20)
    
def initRING():
    a, s = exchange('AT\\R0', 'OK', 2)
    
def activateGPRS(sim):
    if(sim == 0):
        a, s = exchange('AT+CGDCONT=2,"IP","' + GPRS1_APN + '"', 'OK', 2)
    else:
        a, s = exchange('AT+CGDCONT=2,"IP","' + GPRS2_APN + '"', 'OK', 2)
    if(a == 0):
        a, s = exchange('AT#SCFG=6,2,300,90,300,50', 'OK', 2)
        if(a == 0):
            if(sim == 0):
                a, s = exchange('AT#SGACT=2,1,"' + GPRS1_USER + '","' + GPRS1_PASSWORD + '"', 'OK', 20)
            else:
                a, s = exchange('AT#SGACT=2,1,"' + GPRS2_USER + '","' + GPRS2_PASSWORD + '"', 'OK', 20)
            if(a == 0):
                return 0
    return -1
    
def checkGPRS():
    a, s = exchange('AT#SGACT?', 'OK', 2)
    if(a == 0):
        pos = s.find('#SGACT: 2')
        if(pos != -1):
            st = s[pos + 10]
            if(st == '1'):
                return 0
    return -1

def pingTest():
    a, s = exchange('AT#SD=6,0,' + PING_PORT + ',"' + PING_HOST + '",0,0,1', 'OK', 20)
    if(a == 0):
        a, s = exchange('AT#SH=6', 'OK', 20)
        if(a == 0):
            return 0
    return -1
    
def blinkLed(num):
    for i in range(num):
        GPIO.setSLED(1, 5, 5)
        MOD.sleep(1)
        GPIO.setSLED(0, 5, 5)
        MOD.sleep(1)

########################################################
# Machine states
########################################################
ST_CHECK_CREG = 0
ST_CHECK_CONTEXT = 1
ST_PING = 2
ST_ACTIVATE_GPRS = 3
ST_SWITCH_SIM = 4

########################################################
# Main loop
########################################################
try:
    initWatchdog()
    initGPIO()
    initRING()

    activeSim = 0
    
    registerFailCounter = 0
    pingFailCounter = 0
    contextFailCounter = 0
    
    state = ST_CHECK_CREG
    
    while(1):
        debug('Reset watchdog, state=%d' % (state))
        resetWatchdog()
        if(state == ST_CHECK_CREG):
            creg = checkCREG()
            debug('Registration: %d' % (creg))
            if(creg == RESULT_OK):
                state = ST_CHECK_CONTEXT
            else:
                MOD.sleep(MAIN_LOOP_PERIOD * 10)
                registerFailCounter = registerFailCounter + 1
        elif(state == ST_CHECK_CONTEXT):
            gprs = checkGPRS()
            debug('Context: %d' % (gprs))
            if(gprs == RESULT_OK):
                state = ST_PING
            else:
                state = ST_ACTIVATE_GPRS
        elif(state == ST_PING):
            ping = pingTest()
            debug('Ping: %d' % (ping))
            if(ping == RESULT_OK):
                debug('Connection OK')
                blinkLed(activeSim + 1)
                MOD.sleep(MAIN_LOOP_PERIOD * 10)
                registerFailCounter = 0
                contextFailCounter = 0
                pingFailCounter = 0
                state = ST_CHECK_CREG
            else:
                MOD.sleep(MAIN_LOOP_PERIOD * 10)
                pingFailCounter = pingFailCounter + 1
        elif(state == ST_ACTIVATE_GPRS):
            gprs = activateGPRS(activeSim)
            if(gprs == RESULT_OK):
                state = ST_CHECK_CONTEXT
            else:
                MOD.sleep(MAIN_LOOP_PERIOD * 10)
                contextFailCounter = contextFailCounter + 1
        elif(state == ST_SWITCH_SIM):
            if(activeSim == 0):
                debug('Switch to SIM2')
                activeSim = 1
                enableSIM(activeSim)
            else:
                debug('Switch to SIM1')
                activeSim = 0
                enableSIM(activeSim)
            state = ST_CHECK_CREG
            registerFailCounter = 0
            contextFailCounter = 0
            pingFailCounter = 0
        
        if((registerFailCounter >= MAX_REGISTER_FAILS) or (pingFailCounter >= MAX_PING_FAILS) or (contextFailCounter >= MAX_CONTEXT_FAILS)):
            state = ST_SWITCH_SIM
            
except Exception, e:
    reboot()
    